#include "pch.h"
#include "Common.hpp"
#include "CfgParse.hpp"

CCfgParser::CCfgParser() {
	m_szFileName[0]  = TEXT('\0');
	m_iNumberOfAtoms = 0;
	m_iLine          = 0;
	m_fError         = false;
	m_fOpened        = false;
}

CCfgParser::CCfgParser(LPCTSTR szFileName) {
	// keep file name
	lstrcpy( m_szFileName, szFileName );
	// reset parameters
	m_iNumberOfAtoms = 0;
	m_iLine          = 0;
	// check the file access
	if (_taccess( szFileName, 0 ) == 0) {
		// open the file and set flags
		char	szOemFileName[MAX_PATH];
		CharToOem( szFileName, szOemFileName );
		SetFileApisToOEM();
		m_inStream.open( szOemFileName );
		SetFileApisToANSI();
		if (m_inStream) {
			m_fOpened = true;
			m_fError  = false;
		}
		else {
			m_fOpened = false;
			m_fError  = true;
		}
	}
	else {
		m_fError  = true;
		m_fOpened = false;
	}
}

bool CCfgParser::Open(LPCTSTR szFileName) {
	// if some file was already opened, close it and free line memory
	Close();
	// keep file name
	lstrcpy( m_szFileName, szFileName );
	// reset parameters
	m_iNumberOfAtoms = 0;
	m_iLine          = 0;
	if (_taccess( szFileName, 0) == 0) {
		char	szOemFileName[MAX_PATH];
		CharToOem( szFileName, szOemFileName );
		SetFileApisToOEM();
		m_inStream.open( szFileName );
		SetFileApisToANSI();
		if (m_inStream) {
			m_fOpened = true;
			m_fError  = false;
		}
		else {
			m_fOpened = false;
			m_fError  = true;
		}
	}
	else {
		m_fOpened = false;
		m_fError  = true;
	}
	return (m_fOpened);
}

void CCfgParser::Close() {
	if (m_fOpened)
		m_inStream.close();
	FreeLineMemory();
	m_iNumberOfAtoms = 0;
	m_iLine          = 0;
	m_fError         = false;
	m_fOpened        = false;
}

CCfgParser::~CCfgParser() {
	Close();
}

void CCfgParser::ReadLine() {
	FreeLineMemory();
	m_inStream.getline( m_szOemBuf, LINE_SIZE );
	OemToChar( m_szOemBuf, m_szBuf ); 
	m_fError = (m_inStream == 0);
	if (!m_fError) {
		m_iLine++;
		ParseLine();
	}
}

LPTSTR CCfgParser::operator [] (int i) {
	assert( i >= 0 && i < m_iNumberOfAtoms );
	return ( m_vLineAtoms[i] );
}

void CCfgParser::ParseLine() {
	int	i, j;
	LPTSTR	szAtom;

	i = 0;
	while (m_szBuf[i] != _T('\0')) {
		// skip spaces and tabs
		while (m_szBuf[i] == _T(' ') || m_szBuf[i] == _T('\011'))
			i++;
		// check end of line and start of remark
		if (m_szBuf[i] == _T(';') || m_szBuf[i] == _T('\0'))
			break;
		// check double quotes
		if (m_szBuf[i] == _T('"')) {
			j = i;
			// go through the atom
			i++;
			while (m_szBuf[i] != _T('"') && m_szBuf[i] != _T('\0'))
				i++;
			// check for closing quotes
			if (m_szBuf[i] == _T('\0')) {
				m_fError = true;
				break;
			}
			// ok, buf[i] == '"'
			i++;
		}
		else {
			j = i;
			while (m_szBuf[i] != _T(' ') && m_szBuf[i] != _T('\011') && 
				m_szBuf[i] != _T(';') && m_szBuf[i] != _T('\0'))
				i++;
		}
		szAtom = new TCHAR[i-j+1];
		lstrcpyn( szAtom, m_szBuf + j, i-j+1 );
		m_vLineAtoms.push_back( szAtom );
		m_viPositions.push_back( j );
		m_iNumberOfAtoms++;
	}
	if (m_fError)
		FreeLineMemory();
}

void CCfgParser::FreeLineMemory() {
	while (!m_vLineAtoms.empty()) {
		LPTSTR	szAtom = m_vLineAtoms.back();
		m_vLineAtoms.pop_back();
		delete [] szAtom;
	}
	m_viPositions.clear();
	m_iNumberOfAtoms = 0;
}

int CCfgParser::Where(int i) {
	if (i < 0 || i >= m_iNumberOfAtoms)
		return (-1);
	return (m_viPositions[i]); 
}


void CCfgParser::LogError(LPCTSTR szErrorMessage) {
	g_vars.m_log << szErrorMessage
		     << TEXT(" in file ") << m_szFileName
		     << TEXT(" at line ") << m_iLine
		     << TEXT_EOL;
}
